{extends file="layout/layout.tpl"}
{block name=main}
    <div class="slim-mainpanel">
      <div class="container">
        <div class="slim-pageheader">
          <ol class="breadcrumb slim-breadcrumb">
            <li class="breadcrumb-item"><a href="#">User</a></li>
            <li class="breadcrumb-item"><a href="#">License</a></li>
            <li class="breadcrumb-item active" aria-current="page">List</li>
          </ol>
          <h6 class="slim-pagetitle">Licenses</h6>
        </div>
        <div class="section-wrapper">
        {if $msg}
          <div class="alert alert-success mg-b-0" role="alert">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">×</span>
            </button>
            <strong>[SUCCESS]</strong> {$msg}
          </div><br>
          {/if} 
          <div class="table-wrapper">
            <table id="datatable1" class="table display responsive scroll">
              <thead>
                <tr>
                  <th class="wd-10p">LicenseId</th>
                  <th class="wd-15p">Alias</th>
                  <th class="wd-15p">Product</th>
                  <th class="wd-15p">Plan</th>
                  <th class="wd-20p">Expire</th>
                  <th class="wd-10p">Status</th>
                  <th class="wd-10p">Action</th>
                </tr>
              </thead>
              <tbody>
              {foreach key=i item=k from=$license}
                <tr>
                  <td>{$k['LicenseId']}</td>
                  <td>{$k['Alias']}</td>
                  <td>{$plans[$k['ProductId']]} - {$packed[$k['PackageIndex']]}</td>
                  {if $k['PackageIndex'] === (0)}<td>{$plansmall[$k['PlanIndex']]}</td>{/if}
                  {if $k['PackageIndex'] === (1)}<td>{$planmedium[$k['PlanIndex']]}</td>{/if}
                  {if $k['PackageIndex'] === (2)}<td>{$planlarge[$k['PlanIndex']]}</td>{/if}
                  <td>{$k['Expire']}</td>
                  {if {$k['Status']===(0)} }<td><button style="height:25px;width:92px;padding:0px 13px;font-size:13px;" class="btn btn-oblong btn-danger active">Suspended</button></td>{/if}
                  {if {$k['Status']===(1)} }<td><button style="height:25px;width:66px;padding:0px 13px;font-size:13px;" class="btn btn-oblong btn-success active">Active</button></td>{/if}
                  <td><a href="{base_url()}/user/license/edit/{$k['LicenseId']}" style="font-size:13px;"class="btn btn-oblong btn-primary bd-0">Editar</button></td>
                </tr>
              {/foreach}
              </tbody>
            </table>
          </div><!-- table-wrapper -->
        </div><!-- section-wrapper -->
      </div><!-- container -->
    </div><!-- slim-mainpanel -->
    {/block}