{extends file="layout/layout.tpl"}
{block name=main}

<div class="slim-mainpanel">
      <div class="container">
        <div class="slim-pageheader">
          <ol class="breadcrumb slim-breadcrumb">
            <li class="breadcrumb-item"><a href="#">User</a></li>
            <li class="breadcrumb-item"><a href="#">Settings</a></li>
            <li class="breadcrumb-item active" aria-current="page">Edit</li>
          </ol>
          <h6 class="slim-pagetitle">Edita Perfil</h6>
        </div><!-- slim-pageheader -->

        <div class="section-wrapper">
          {if $error}
          <div class="alert alert-danger mg-b-0" role="alert">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">×</span>
            </button>
            <strong>[ERROR]</strong> {$error->listErrors()}
          </div><br>
          {/if}
          {if $msg}
          <div class="alert alert-success mg-b-0" role="alert">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">×</span>
            </button>
            <strong>OK</strong> {$msg}
          </div><br>
          {/if}
         
          <div class="form-layout">
            <div class="row row-sm mg-t-20">
            {if $smarty.session.Nivel eq 2}
          <div class="col-lg-6">
             <form method="POST" action="{base_url()}/user/settings">
            <div class="section-wrapper">
              <label class="section-title">Alterar Email</label>
              <div class="form-layout form-layout-4">
                <div class="row">
                  <label class="col-sm-4 form-control-label">Email Atual: <span class="tx-danger">*</span></label>
                  <div class="col-sm-8 mg-t-10 mg-sm-t-0">
                    <input type="text" class="form-control" value="{$user->Mail}" placeholder="" disabled>
                  </div>
                </div><!-- row -->
                <div class="row mg-t-20">
                  <label class="col-sm-4 form-control-label"><span class="tx-danger">*</span> Novo Email:</label>
                  <div class="col-sm-8 mg-t-10 mg-sm-t-0">
                    <input type="text" class="form-control" name="mail" placeholder="Novo Email">
                  </div>
                </div>              
                <div class="form-layout-footer mg-t-30">
                  <button class="btn btn-primary bd-0">Alterar</button>
                  <button class="btn btn-secondary bd-0">Cancel</button>
                </div><!-- form-layout-footer -->
              </div><!-- form-layout -->
            </div><!-- section-wrapper -->
             <input type="hidden" name="{csrf_token()}" value="{csrf_hash()}" />
            </form>
          </div><!-- col-6 -->
          {/if}

          <div class="col-lg-6 mg-t-20 mg-lg-t-0">
            <form method="POST" action="{base_url()}/user/settings">
            <div class="section-wrapper">
              <label class="section-title">Alterar Senha</label>
              <div class="form-layout form-layout-5">
                <div class="row">
                  <label class="col-sm-4 form-control-label"><span class="tx-danger">*</span> Senha Atual:</label>
                  <div class="col-sm-8 mg-t-10 mg-sm-t-0">
                    <input type="password" class="form-control" name="pass" placeholder="Cloque sua senha atual">
                  </div>
                </div><!-- row -->
                <div class="row mg-t-20">
                  <label class="col-sm-4 form-control-label"><span class="tx-danger">*</span> Nova Senha:</label>
                  <div class="col-sm-8 mg-t-10 mg-sm-t-0">
                    <input type="password" class="form-control" name="newpass" placeholder="Nova senha">
                  </div>
                </div> 
               <div class="row mg-t-20">
                  <label class="col-sm-4 form-control-label"><span class="tx-danger">*</span> Confirmar Senha:</label>
                  <div class="col-sm-8 mg-t-10 mg-sm-t-0">
                    <input type="password" class="form-control" name="confirmpassword" placeholder="Confirmar senha">
                  </div>
                </div>            
                <div class="row mg-t-30">
                  <div class="col-sm-8 mg-l-auto">
                    <div class="form-layout-footer">
                      <button  class="btn btn-primary bd-0">Alterar</button>
                      <button class="btn btn-secondary bd-0">Cancel</button>
                    </div><!-- form-layout-footer -->
                  </div><!-- col-8 -->
                </div>
              </div><!-- form-layout -->
            </div><!-- section-wrapper -->
            <input type="hidden" name="{csrf_token()}" value="{csrf_hash()}" />          
            </form>
          </div><!-- col-6 -->
          
        </div>
          </div><!-- form-layout -->
        
        </div><!-- section-wrapper -->

      </div><!-- container -->
    </div>
{/block}