<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (is_file(SYSTEMPATH . 'Config/Routes.php')) {
    require SYSTEMPATH . 'Config/Routes.php';
}

/*
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Home');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
// The Auto Routing (Legacy) is very dangerous. It is easy to create vulnerable apps
// where controller filters or CSRF protection are bypassed.
// If you don't want to define all routes, please use the Auto Routing (Improved).
// Set `$autoRoutesImproved` to true in `app/Config/Feature.php` and set the following to true.
//$routes->setAutoRoute(false);

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.
$routes->get('/', 'Home::index', ['filter' => 'SessionGuard']);

$routes->get('/help', 'Panel\HelpController::index',['filter' => 'SessionGuard']);
$routes->group('panel', ['namespace' => 'App\Controllers\User', 'filter' => 'SessionGuard'], static function ($routes){
        $routes->get('plans', 'BuyController::index');
     
});
$routes->group('auth', ['namespace' => 'App\Controllers\User', 'filter' => 'SessionGuard'], static function ($routes){
    $routes->get('buy', 'BuyController::index', ['filter' => 'AuthGuard']);
    $routes->get('signin', 'SignInController::index');
    $routes->post('signin', 'SignInController::loginAuth');
    $routes->get('signup', 'SignUpController::index');
    $routes->post('signup', 'SignUpController::store');
    $routes->get('logout', 'UserController::logOut', ['filter' => 'AuthGuard']);
     
});

$routes->group('user', ['namespace' => 'App\Controllers\User', 'filter' => 'SessionGuard'], static function ($routes) {
    $routes->get('settings', 'SettingsController::index');
    $routes->post('settings', 'SettingsController::changemail');
    $routes->post('settings', 'SettingsController::changepass');
    $routes->get('downloads', 'DownloadsController::index');
    $routes->get('signin', 'SignInController::index');
    $routes->post('signin', 'SignInController::loginAuth');
    $routes->get('signup', 'SignUpController::index');
    $routes->post('signup', 'SignUpController::store');
    $routes->get('licenses', 'LicenseController::index', ['filter' => 'AuthGuard']);
    $routes->get('license/edit/(:num)', 'EditLicenseController::index/$1', ['filter' => 'AuthGuard']);
    $routes->post('license/edit/(:num)', 'EditLicenseController::update/$1', ['filter' => 'AuthGuard']);
    $routes->get('logout', 'UserController::logOut', ['filter' => 'AuthGuard']); 
    $routes->get('overview', 'OverViewController::index');
     
});

$routes->group('admin', ['namespace' => 'App\Controllers\Admin', 'filter' => 'AuthGuard', 'filter' => 'AdminGuard'], static function ($routes) {
    $routes->get('licenses', 'LicenseController::index');
    $routes->get('addlicense', 'CreateLicenseController::index');
    $routes->post('addlicense', 'CreateLicenseController::store');
    $routes->get('users', 'UserController::index');
    $routes->get('createuser', 'CreateUserController::index');
    $routes->post('createuser', 'CreateUserController::store');
    $routes->get('user/edit/(:num)', 'EditUserController::index/$1');
    $routes->post('user/edit/(:num)', 'EditUserController::update/$1');
    $routes->get('user/delete/(:num)', 'EditUserController::DeleteUser/$1');
    $routes->get('license/edit/(:num)', 'EditLicenseController::index/$1');
    $routes->get('license/delete/(:num)', 'EditLicenseController::DeleteLicense/$1');
    $routes->post('license/edit/(:num)', 'EditLicenseController::update/$1');

});
/*
/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (is_file(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
