<?php

namespace App\Controllers\Admin;
use App\Models\UserModel;
use App\Models\LicenseModel;
use App\Controllers\BaseController;
class EditLicenseController extends BaseController
{
    protected $session;
    public function __construct(){
        helper(['form']);
        $this->session = service('session');
    }  
    public function index($seg1 = false)
    {
        $userModel = new UserModel();
        $licenseModel = new LicenseModel();
    	$user = $licenseModel->where('LicenseId', $seg1)->findAll();
        if(!$this->license_exist($seg1)){
            return redirect()->to('/admin/licenses');
        }
        $data['title'] = 'License Edit';
        $data['user']= (object)$user[0];
        $data['msg'] = $this->session->getFlashdata('msg');
        $data['error'] = $this->session->getFlashdata('error');
        $this->smartyView('admin/editlicense', $data);
    }

   public function is_unique($table,$value)
    {
        $userModel = new UserModel();
        $user = $userModel->where($table, $value)->findAll();
        if(!empty($user[0])){
            return TRUE;
        }else {
            return FALSE;
        }
    }
   public function license_exist($value)
    {

        $licenseModel = new licenseModel();
        $user = $licenseModel->where('LicenseId', $value)->findAll();
        if(!empty($user[0])){
            return TRUE;
        }else {
            return FALSE;
        }
    }
    public function DeleteLicense($seg1 = false)
	{
        if(!$this->license_exist($seg1)){
            return redirect()->to('/admin/licenses');
        }
		
		$licenseModel = new LicenseModel();
		$user = $licenseModel->where('LicenseId', $seg1)->findAll();
		$licenseModel->where('LicenseId', $seg1, 'Information2', $user[0]['Information2'])->delete();
		if($licenseModel){
			 return redirect()->to('/admin/licenses')->with('msg', "Licensa Removida");
		}

	}
    public function update($seg1 = false)
    {
         helper(['form']);
         $session = session();
         $licenseModel = new LicenseModel();
         $rules = [
            'ip' => [
                    'label'  => 'Machine IP',
                    'rules'  => 'required|min_length[5]',
                    'errors' => [
                    'required' => 'Campo {field} nao pode ser vazio',
                    'min_length' => '{field} deve ter no mino 4 letras ou numeros',
                    'max_length' => '{field} deve ter no maximo 20 letras ou numeros'
                ]
            ],
            'hdid' => [
                    'label'  => 'HardwareID',
                    'rules'  => 'required|min_length[20]',
                    'errors' => [
                    'required' => 'Campo {field} nao pode ser vazio',
                    'min_length' => '{field} deve ter no mino 20 letras ou numeros',
                    'max_length' => '{field} deve ter no maximo 100 letras ou numeros'
                ]
            ],
            'expire' => [
                    'label'  => 'Data',
                    'rules'  => 'required|min_length[5]',
                    'errors' => [
                    'required' => 'Campo {field} nao pode ser vazio',
                    'min_length' => '{field} deve ter no mino 20 letras ou numeros',
                    'max_length' => '{field} deve ter no maximo 100 letras ou numeros'
                ]
        ],
        'changeplan' => [
                'label'  => 'Change Plan',
                'rules'  => 'required',
                'errors' => [
                'required' => 'Sua {field} nao pode ser vazio'
            ]
        ],
        'changepacked' => [
            'label'  => 'Change Packed',
            'rules'  => 'required',
            'errors' => [
            'required' => 'Sua {field} nao pode ser vazio'
            ],
        ]

        ];
        $user = $licenseModel->where('LicenseId', $seg1)->findAll();
        if($this->validate($rules)){
            
            $data = [
                'Information1'     => $this->request->getVar('ip'),
                'Information2'     => $this->request->getVar('hdid'),
                'PackageIndex'    => $this->request->getVar('updaten'),                
                'ProductId' => $this->request->getVar('plan'),
                'Status' => $this->request->getVar('status'),
                'Expire' => $this->request->getVar('expire'),
                'PlanIndex'    => $this->request->getVar('changeplan'),
                'PackageIndex'    => $this->request->getVar('changepacked')
            ];
            $licenseModel->update($seg1, $data);
            return redirect()->to('/admin/license/edit/'.$seg1)->with('msg', "Licensa Atualizada");
        }else{
            return redirect()->to('/admin/license/edit/'.$seg1)->with('error', $this->validator); 
        }
        
          
    }
  
}
