<?php

namespace App\Controllers\User;
use App\Models\UserModel;
use App\Models\LicenseModel;
use App\Controllers\BaseController;
class SettingsController extends BaseController
{
    protected $session;
    public function __construct(){
        helper(['form']);
        $this->session = service('session');
    }
    public function index(){  	

        $userModel = new UserModel();
    	$user = $userModel->where('Id', session()->get('id'))->findAll();
        $data['title'] = 'Settings';
    	$data['user']= (object)$user[0];
        $data['msg'] = $this->session->getFlashdata('msg');
        $data['error'] = $this->session->getFlashdata('error');
        $this->smartyView('/user/settings', $data);
    }

   public function is_unique($table,$value)
    {
        $userModel = new UserModel();
        $user = $userModel->where($table, $value)->findAll();
        if(!empty($user[0])){
            return TRUE;
        }else {
            return FALSE;
        }
    }

    public function changemail()
    {
         $userModel = new UserModel();
         $rules = [
            'mail' => [
                    'label'  => 'Novo Email',
                    'rules'  => 'required|min_length[4]|max_length[100]|valid_email',
                    'errors' => [
                    'matches' => 'Confirmaçao de senha nao concide',
                    'required' => 'Campo {field} nao pode ser vazio',
                    'min_length' => '{field} deve ter no mino 4 letras ou numeros',
                    'max_length' => '{field} deve ter no maximo 20 letras ou numeros',
                    'valid_email' => '{field} Voce deve usar um email valido'
                ]
            ]
        ];
        $user = $userModel->where('Id', session()->get('id'))->findAll();

        if($this->validate($rules)){
            if($this->is_unique('Mail', $this->request->getVar('mail'))){
                return redirect()->to('/user/settings')->with('msg', "Email Registrado");
            }else{
            $data = [
                'Mail'     => $this->request->getVar('mail')            
            ];
                $userModel->update(session()->get('id'), $data);
                return redirect()->to('/user/settings')->with('msg', "Email alterado com sucesso");
            }
        }else{
            return redirect()->to('/user/settings')->with('error', $this->validator);    
        }                 
    }

  public function changepass()
    {   
         $userModel = new UserModel();
         $rules = [
            'pass' => [
                    'label'  => 'Senha Atual',
                    'rules'  => 'required|min_length[4]|max_length[20]',
                    'errors' => [
                    'matches' => 'Confirmaçao de senha nao concide',
                    'required' => 'Campo {field} nao pode ser vazio',
                    'min_length' => '{field} deve ter no mino 4 letras ou numeros',
                    'max_length' => '{field} deve ter no maximo 20 letras ou numeros'
                ]
            ],
            'newpass' => [
                    'label'  => 'Nova Senha',
                    'rules'  => 'required|min_length[4]|max_length[20]',
                    'errors' => [
                    'matches' => 'Confirmaçao de senha nao concide',
                    'required' => 'Campo {field} nao pode ser vazio',
                    'min_length' => '{field} deve ter no mino 4 letras ou numeros',
                    'max_length' => '{field} deve ter no maximo 20 letras ou numeros'
                ]
            ],
            'confirmpassword' => [
                    'label'  => 'Confirmar Senha',
                    'rules'  => 'required|min_length[4]|matches[newpass]',
                    'errors' => [
                    'matches' => 'Confirmaçao de senha nao concide',
                    'required' => 'Campo {field} nao pode ser vazio',
                    'min_length' => '{field} deve ter no mino 4 letras ou numeros',
                    'max_length' => '{field} deve ter no maximo 20 letras ou numeros'
                ]
            ]
        ];

        $user = $userModel->where('Id',session()->get('id'))->findAll();

        if($this->validate($rules)){
            if($this->request->getVar('pass') !== $user[0]['Password']){
                 return redirect()->to('/user/settings')->with('msg', "Senha atual não corresponde");
            }else{
            $data = [

                'Password' => $this->request->getVar('newpass')       
            ];}
            $userModel->update(session()->get('id'), $data);
            return redirect()->to('/user/settings')->with('msg', "Senha alterada com sucesso");
        }
            else{
            return redirect()->to('/user/settings')->with('error', $this->validator);   
        }
        
          
    }
  
}
