{extends file="layout/layout.tpl"}
{block name=main}

<div class="slim-mainpanel">
      <div class="container">
        <div class="slim-pageheader">
          <ol class="breadcrumb slim-breadcrumb">
            <li class="breadcrumb-item"><a href="#">Admin</a></li>
            <li class="breadcrumb-item"><a href="#">User</a></li>
            <li class="breadcrumb-item active" aria-current="page">Edit</li>
          </ol>
          <h6 class="slim-pagetitle">Edit USER</h6>
        </div><!-- slim-pageheader -->

        <div class="section-wrapper">
          {if $error}
          <div class="alert alert-danger mg-b-0" role="alert">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">×</span>
            </button>
            <strong>[ERROR]</strong> {$error->listErrors()}
          </div><br>
          {/if}
          {if $msg}
          <div class="alert alert-success mg-b-0" role="alert">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">×</span>
            </button>
            <strong>[SUCCESS]</strong> {$msg}
          </div><br>
          {/if}
          <form method="POST" action="/admin/user/edit/{$user->Id}">
          <div class="form-layout">
            <div class="row mg-b-25">
              <div class="col-lg-4">
                <div class="form-group">
                  <label class="form-control-label">Name: <span class="tx-danger">*</span></label>
                  <input class="form-control" type="text" name="user" value="{$user->Name}" placeholder="Enter Username">
                </div>
              </div><!-- col-4 -->
              <div class="col-lg-4">
                <div class="form-group">
                  <label class="form-control-label">Email: <span class="tx-danger">*</span></label>
                  <input class="form-control" type="text" name="email" value="{$user->Mail}" placeholder="Enter Email">
                </div>
              </div><!-- col-4 -->
              <!-- col-4 -->
              <div class="col-lg-4">
                <div class="form-group mg-b-10-force">
                  <label class="form-control-label">Level: <span class="tx-danger">*</span></label>
                  <select class="form-control select2" name="status" data-placeholder="Choose Status" tabindex="-1" aria-hidden="true">
                    <option label="Choose Status"></option>
                    <option value="0" {$user->Status === (0) ? 'selected' : ''}>Desativada</option>
                    <option value="1" {$user->Status === (1) ? 'selected' : ''}>Ativada</option>
                    <option value="16" {$user->Status === (16) ? 'selected' : ''}>Banida</option>
                    
                  </select>

              </div>
              </div><!-- col-4 -->

              <div class="col-lg-8">
                <div class="form-group mg-b-10-force">
                  <label class="form-control-label">Date Create: <span class="tx-danger">*</span></label>
                  <input class="form-control" type="text" name="date" value="{$user->Date_Create}" placeholder="Date" disabled>
                </div>
              </div><!-- col-8 -->
              <div class="col-lg-4">
                <div class="form-group mg-b-10-force">
                  <label class="form-control-label">Level: <span class="tx-danger">*</span></label>
                  <select class="form-control select2" name="nivel" data-placeholder="Level" tabindex="-1" aria-hidden="true">
                    <option label="Choose Level"></option>
                    <option value="1" {$user->Nivel === (1) ? 'selected' : ''}>Normal User</option>
                    <option value="2" {$user->Nivel === (2) ? 'selected' : ''}>Admin</option>
                  </select>

              </div>
              </div>

              <div class="col-lg-8">
                <div class="form-group">
                  <label class="form-control-label">Password: <span class="tx-danger">*</span></label>
                  <input class="form-control" type="password" name="password" value="{$user->Password}" placeholder="Enter password">
                </div>
              </div><!-- col-4 -->

            </div><!-- row -->

            <div class="form-layout-footer">
              <button type="submit" id="update" class="btn btn-primary bd-0">Update</button>
              <button class="btn btn-secondary bd-0">Cancel</button>
            </div><!-- form-layout-footer -->
          </div><!-- form-layout -->
                    <input type="hidden" name="{csrf_token()}" value="{csrf_hash()}" />
        </form>
        </div><!-- section-wrapper -->

      </div><!-- container -->
    </div>
 {/block}