<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <title>AuthPanel - {$title}</title>

    <!-- vendor css -->
    <link href="/lib/font-awesome/css/font-awesome.css" rel="stylesheet">
    <link href="/lib/Ionicons/css/ionicons.css" rel="stylesheet">
    <link href="/lib/datatables/css/jquery.dataTables.css" rel="stylesheet">
    <link href="/lib/select2/css/select2.min.css" rel="stylesheet">

    <!-- Slim CSS -->
    <link rel="stylesheet" href="/css/slim.css">
    <link rel="stylesheet" href="/css/slim.one.css">

  </head>
  <body>
    <div class="slim-header">
      <div class="container">
        <div class="slim-header-left">
          <h2 class="slim-logo"><a href="index.html">AUTH<span>PANEL</span></a></h2>

        </div><!-- slim-header-left -->
        <div class="slim-header-right">
          <div class="dropdown dropdown-a">
            <a href="" class="header-notification" data-toggle="dropdown">
              <i class="icon ion-ios-bolt-outline"></i>
            </a>
          
          </div><!-- dropdown -->
          {if $smarty.session.isLoggedIn}
          <div class="dropdown dropdown-c">
            <a href="#" class="logged-user" data-toggle="dropdown">
              
              <span>{$smarty.session.name}</span>
              <i class="fa fa-angle-down"></i>
            </a>
            <div class="dropdown-menu dropdown-menu-right">
              <nav class="nav">
                <a href="/user/settings" class="nav-link"><i class="icon ion-ios-gear"></i> Account Settings</a>
                <a href="/user/logout" class="nav-link"><i class="icon ion-forward"></i> Sign Out</a>
              </nav>
            </div><!-- dropdown-menu -->
          </div><!-- dropdown -->
        {/if}
        </div><!-- header-right -->
      </div><!-- container -->
    </div><!-- slim-header -->

    <div class="slim-navbar">
      <div class="container">
        <ul class="nav">
          <li class="nav-item">
            <a class="nav-link" href="/">
              <i class="icon ion-ios-home-outline"></i>
              <span>Home</span>
              <span class="square-8"></span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/user/buy">
              <i class="icon ion-ios-bolt-outline"></i>
              <span>Plans</span>
            </a>
          </li>

          <li class="nav-item">
            <a class="nav-link" href="/help">
              <i class="icon ion-help"></i>
              <span>Help</span>
            </a>
          </li>
          {if $smarty.session.isLoggedIn}

          <li class="nav-item">
            <a class="nav-link" href="/user/licenses">
              <i class="icon ion-key"></i>
              <span>Licenses</span>
            </a>
          </li>
          <li class="nav-item with-sub">
            <a class="nav-link" href="#">
              <i class="icon ion-grid"></i>
              <span>Misc</span>
            </a>
            <div class="sub-item">
              <ul>
                <li><a href="/user/downloads">Server Files</a></li>
              </ul>
            </div><!-- sub-item -->
          </li>
        {if $smarty.session.Nivel eq 2}
          <li class="nav-item with-sub">
            <a class="nav-link" href="#">
              <i class="icon ion-grid"></i>
              <span>Admin</span>
            </a>
            <div class="sub-item">
              <ul>
                <li><a href="/admin/users">Users</a></li>
                <li><a href="/admin/licenses">Licences</a></li>
                <li><a href="/admin/createlicenses">Create License</a></li>
                <li><a href="/admin/createuser">Create User</a></li>
              </ul>
            </div><!-- sub-item -->
          </li>
        {/if}
          {else}

          <li class="nav-item">
            <a class="nav-link" href="/user/signup">
              <i class="icon ion-person-add"></i>
              <span>Registro</span>
            </a>
          </li>

          <li class="nav-item">
            <a class="nav-link" href="/user/signin">
              <i class="icon ion-person"></i>
              <span>Login</span>
            </a>
          </li>
        {/if}

        </ul>
      </div><!-- container -->
    </div><!-- slim-navbar -->
    {block name=main}{/block}
    <div class="slim-footer">
      <div class="container">
        <p>Copyright 2022 &copy; All Rights Reserved. Vinicius Oliveira</p>
        <p>Designed by: <a href="">ThemePixels - Slim</a></p>
      </div><!-- container -->
    </div><!-- slim-footer -->

    <script src="/lib/jquery/js/jquery.js"></script>
    <script src="/lib/popper.js/js/popper.js"></script>
    <script src="/lib/bootstrap/js/bootstrap.js"></script>
    <script src="/lib/jquery.cookie/js/jquery.cookie.js"></script>
    <script src="/lib/datatables/js/jquery.dataTables.js"></script>
    <script src="/lib/datatables-responsive/js/dataTables.responsive.js"></script>
    <script src="/lib/select2/js/select2.min.js"></script>

    <script src="/js/slim.js"></script>
    <script>
      $(function(){
        'use strict';

        $('#datatable1').DataTable({
          responsive: true,
          language: {
            searchPlaceholder: 'Search...',
            sSearch: '',
            lengthMenu: '_MENU_ items/page',
          }
        });

        $('#datatable2').DataTable({
          bLengthChange: false,
          searching: false,
          responsive: true
        });

        // Select2
        $('.dataTables_length select').select2({ minimumResultsForSearch: Infinity });

      });
    </script>
  </body>
</html>
