{extends file="layout/layout.tpl"}
{block name=main}
    <div class="slim-mainpanel">
      <div class="container">
        <div class="slim-pageheader">
          <ol class="breadcrumb slim-breadcrumb">
            <li class="breadcrumb-item"><a href="#">User</a></li>
            <li class="breadcrumb-item"><a href="#">License</a></li>
            <li class="breadcrumb-item active" aria-current="page">List</li>
          </ol>
          <h6 class="slim-pagetitle">Licenses</h6>
        </div><!-- slim-pageheader -->

        <div class="section-wrapper">
        
          <div class="table-wrapper">
            <table id="datatable1" class="table display responsive nowrap">
              <thead>
                <tr>
                  <th class="wd-10p">LicenseId</th>
                  <th class="wd-20p">Alias</th>
                  <th class="wd-10p">Product</th>
                  <th class="wd-15p">Plan</th>
                  <th class="wd-15p">Expire</th>
                  <th class="wd-20p">Status</th>
                  <th class="wd-20p">Action</th>

                </tr>
              </thead>
              <tbody>
                 {foreach key=i item=k from=$license}
                <tr>
                  <td>{$k['LicenseId']}</td>
                  <td>{$k['Alias']}</td>
                  <td>{$plans[$k['ProductId']]} - {$packed[$k['PackageIndex']]}</td>
                  {if $k['PackageIndex'] === (0)}<td>{$plansmall[$k['PlanIndex']]}</td>{/if}
                  {if $k['PackageIndex'] === (1)}<td>{$planmedium[$k['PlanIndex']]}</td>{/if}
                  {if $k['PackageIndex'] === (2)}<td>{$planlarge[$k['PlanIndex']]}</td>{/if}
                  <td>{$k['Expire']}</td>
                  <td>{$k['Status']===(1) ? 'Ativada':'Desativada'}</td>
                  <td><a href="/user/license/edit/{$k['LicenseId']}" class="btn btn-success">Editar</button></td>
                </tr>
               {/foreach}
              </tbody>
            </table>
          </div><!-- table-wrapper -->
        </div><!-- section-wrapper -->
      </div><!-- container -->
    </div><!-- slim-mainpanel -->
    {/block}